%% SIR_simtest
%
% Plots a comparison of susceptible and infected populations 
%
% Uses sir_sim.m, 2020/10/26 version
%
% User specifies values for 4 parameters:
%   R0 is the basic reproductive number
%   T is the mean infectious duration
%   I0 is the initial infectious fraction
%   V is the initial immune fraction
%
% by Glenn Ledder
% written 2020/06/21
% revised 2020/11/08
%
% direct comments to gledder@unl.edu

%% SCENARIO DATA

R0 = 2.5;
T = 5;
I0 = 0.001;
V = 0;

%% COMMON DATA

target = 0.001;

%% INITIALIZATION

opengl hardwarebasic;
clf
hold on

%% COMPUTATION

gamma = 1/T;
beta = gamma*R0;
[S,I,R] = sir_sim(beta,gamma,I0,V,target);
days = length(I)-1;
new = S(1:days)-S(2:length(S));
new = [0;new];

%% OUTPUT

times = 0:days;

plot(times,S,'LineWidth',1.7)
plot(times,I,'LineWidth',1.7)
plot(times,R,'LineWidth',1.7)
xlabel('days')
ylabel('population fraction')
legend('S','I','R','Location','East')

results = [times',S,I,R,new]
maxI = max(I)
finalS = S(end)

